<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * UserTokenConfirmInfo
 *
 * @ORM\Table(name="user_tokens_confirm_info")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class UserTokenConfirmInfo
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $info
     *
     * @ORM\Column(name="info", type="string", length=50)
     */
    private $info;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_token_id", type="integer")
     */
    private $userTokenId;

    /**
     * @ORM\OneToOne(targetEntity="UserToken", mappedBy="confirmInfo")
     * @ORM\JoinColumn(name="user_token_id", referencedColumnName="id")
     */
    protected $userToken;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set info
     *
     * @param string $info
     * @return UserTokenConfirmInfo
     */
    public function setInfo($info)
    {
        $this->info = $info;
    
        return $this;
    }

    /**
     * Get info
     *
     * @return string 
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * Set userTokenId
     *
     * @param integer $userTokenId
     * @return UserTokenConfirmInfo
     */
    public function setUserTokenId($userTokenId)
    {
        $this->userTokenId = $userTokenId;
    
        return $this;
    }

    /**
     * Get userTokenId
     *
     * @return integer 
     */
    public function getUserTokenId()
    {
        return $this->userTokenId;
    }

    /**
     * Set userToken
     *
     * @param \VM\ApiBundle\Entity\UserToken $userToken
     * @return UserTokenConfirmInfo
     */
    public function setUserToken(\VM\ApiBundle\Entity\UserToken $userToken = null)
    {
        $this->userToken = $userToken;
    
        return $this;
    }

    /**
     * Get userToken
     *
     * @return \VM\ApiBundle\Entity\UserToken 
     */
    public function getUserToken()
    {
        return $this->userToken;
    }
}